% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_curds.R
\name{nlm_curds}
\alias{nlm_curds}
\title{nlm_curds}
\usage{
nlm_curds(p, s, ext = 1)
}
\arguments{
\item{p}{[\code{numerical(x)}]\cr
Vector with percentage(s) to fill with curds (fill with Habitat (value ==
TRUE)).}

\item{s}{[\code{numerical(x)}]\cr
Vector of successive cutting steps for the blocks (split 1 block into x
blocks).}

\item{ext}{[\code{numerical(1)}]\cr
Extent of the resulting raster (0,x,0,x).}
}
\value{
raster
}
\description{
Simulates a curdled neutral landscape model.
}
\details{
Random curdling recursively subdivides the plane into blocks.
At each level of the recursion, a fraction of the this block is declared as
habitat (value == TRUE) while the remaining stays matrix (value == FALSE).
}
\examples{

# simulate random curdling
(random_curdling <- nlm_curds(c(0.5, 0.3, 0.6), c(32, 6, 2)))
\dontrun{
# Visualize the NLM
util_plot(random_curdling, discrete = TRUE)
}

}
\references{
Keitt TH. 2000. Spectral representation of neutral landscapes.
\emph{Landscape Ecology} 15:479-493.
}
\seealso{
\code{\link{nlm_wheys}}
}
