% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getDimensions}
\alias{getDimensions}
\alias{getDimensions.default}
\alias{getDimensions.prcomp}
\alias{getDimensions,prcomp}
\alias{getDimensions.umap}
\alias{getDimensions,umap}
\alias{getDimensions.Seurat}
\alias{getDimensions,Seurat}
\title{Generic method to get a dimensions matrix from obj.}
\usage{
getDimensions(obj, ...)

\method{getDimensions}{default}(obj, ...)

\method{getDimensions}{prcomp}(obj, ...)

\method{getDimensions}{umap}(obj, ...)

\method{getDimensions}{Seurat}(obj, dimName, ...)
}
\arguments{
\item{obj}{The object from which to obtain the dimension(s).}

\item{...}{Additional class-specific parameters for specifying the desired dimension.}

\item{dimName}{The name of the dimension matrix to obtain.}
}
\value{
A matrix with one dimension per column and one named row per observation in obj.
}
\description{
The return value must be NULL or a numeric matrix, each column of which is a (reduced) dimension.
The rows of the returned matrix must be named.
}
\seealso{
\code{\link[=chmAddReducedDim]{chmAddReducedDim()}}
}
