% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analysis.R
\name{TSFit.Volatility}
\alias{TSFit.Volatility}
\title{Volatility Term Structure of futures returns}
\usage{
TSFit.Volatility(parameter.values, parameters, Futures, TTM, dt)
}
\arguments{
\item{parameter.values}{Vector of parameter values of an N-factor model. The \code{NFCP.Kalman.filter} function is designed for
application to \code{optim} type functions, and thus the parameter values and corresponding parameter names are separated by different inputs within the function.}

\item{parameters}{A named vector of parameters of an N-factor model. Function \code{NFCP.Parameters} is recommended.}

\item{Futures}{A Matrix of futures price data. Each column corresponds to a given futures contract, and each row is an observation of the futures contracts.}

\item{TTM}{A vector listing the Time to Maturities of each listed Futures contract from the current observation point.}

\item{dt}{Numeric. The length of the discrete time step (years).}
}
\value{
\code{TSFit.Volatility} returns a matrix with the theoretical and empirical volatility term structure of futures returns, with the number of columns of this matrix coinciding with the number of input futures contracts.
}
\description{
Estimate the Theoretical and Empirical Volatility Term Structure of futures returns
}
\details{
\loadmathjax

The fit of the models theoretical volatility term structure of futures returns to those obtained directly from observed futures prices can be used as an additional measure of robustness for
the models ability to explain the behavior of a commodities term structure. A commodity pricing model should capture all dynamics of a commodities term structure,

The theoretical model volatility term structure of futures returns is given by the following equation:

\mjdeqn{\sigma_F(\tau) = \sum_{i=1}^N \sum_{j=1}^N \sigma_i \sigma_j \rho_{i,j} e^{-(\kappa_i + \kappa_j)\tau}}{sigma_F(tau) = sum_{i = 1, j = 1}^N sigma[i] sigma[j] rho[i,j] e^(-(kappa[i] + kappa[j]) tau)}

Under the case that \mjeqn{\kappa_1 = 0}{kappa[1] = 0}, the model volatility term structure converges to \mjeqn{\sigma_1^2}{sigma[1]^2} as \mjeqn{\tau}{tau} grows large.

The empirical volatility term structure of futures returns is given by:

\mjdeqn{\hat\sigma_F^2(\tau) = \frac{1}{\Delta t}\sum_{i=1}^N(log(F(t_i,\tau)/F(t_i-\Delta t,\tau)) - \bar\mu)^2}{hat(sigma)[F^2](tau) = 1/(Delta * t) sum_{i=1}^N (log(F(t[i],tau) / F(t[i] - Delta t, tau)) - bar(mu))^2}

According to Cortazar and Naranjo (2006): "A larger number of factors gives more flexibility to adjust first and second moments simultaneously, hence explaining why (a) four-factor (may) outperform (a) three-factor one in fitting the volatility term structure."
}
\examples{
### Test the volatility term structure fit of the Schwartz-Smith two-factor model on crude oil:
V_TSFit <- TSFit.Volatility(
 parameter.values = SS.Oil$Two.Factor,
 parameters = names(SS.Oil$Two.Factor),
 Futures = SS.Oil$Stitched.Futures,
 TTM = SS.Oil$Stitched.TTM,
 dt = SS.Oil$dt)

}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
