% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.r
\name{roc}
\alias{roc}
\title{ROC for NEA benchmarks}
\usage{
roc(tpvsfp, mode = "roc", tpr.stop = 1, fpr.stop = 1, coff.z = 1.965,
  coff.fdr = 0.1, cex.main = 1, cex.leg = 0.75, main = NA,
  use.lty = FALSE, print.stats = TRUE, sort_by_letter_and_remove = FALSE)
}
\arguments{
\item{tpvsfp}{a list contaning data for the ROC curve(s) from \code{\link{benchmark}}: \code{cross.z}, \code{cutoffs}, \code{ne}, \code{nv},\code{tp}, \code{fp}, \code{tn}, \code{fn}.}

\item{mode}{either ROC curve (roc) or precision recall curve (prc). default: roc}

\item{tpr.stop}{upper limit for the Y-axis (true positives). default: 1}

\item{fpr.stop}{upper limit for the X-axis (false prositives), default: 1}

\item{coff.z}{the point where to stop the ROC curve (in order to disable, set coff.z to below the minimal possible level)}

\item{coff.fdr}{the point where to put the circle ('cross') at the ROC curve}

\item{cex.main}{font size for the main title}

\item{cex.leg}{font size for the legend}

\item{main}{title name for the plot, default: none}

\item{use.lty}{if different line types should be used for the curves, useful when the number of curves is very big (>10). default:"FALSE"}

\item{print.stats}{add N(edges) and N(vertices) to the legend lines; only works if non-empty $ne and $nv elements are submitted in tpvsfp. default:"TRUE"}

\item{sort_by_letter_and_remove}{enable a specific order for the curves in the legend, set by prefix letters \code{gsub("[A-Z]\\:", "", p1, fixed=F, ignore.case=T)}, such as "a:network1", "b:network-2" etc., whereby a: and b: are removed from the text strings. default:"FALSE"}
}
\description{
Plot ROC curve(s) for benchmarked network(s)
}
\details{
The function \code{\link{roc}} can be called either from inside \code{\link{benchmark}}, or separately. In the latter case, it should receive the first argument as an object of the same type as \code{\link{benchmark}} can return. Generally, a ROC curve encompasses the whole interval from 0\% to 100\% at both axes. However in case of predictions made via network analysis, only the interval with (at least) formally significant scores is of interest (\href{https://bmcbioinformatics.biomedcentral.com/articles/10.1186/1471-2105-15-308}{Merid et.al 2014}).
Therefore the benchmark results are presented as ROC curves that end at minimal acceptable confidence, set via either a z-score cut-off. Additionally, an extra point is denoted that might correspond to \code{cross.z} in \code{\link{roc}}. The scale is given in no. of tested member genes rather then as percentage of the total no. of tests. The scale ranges \code{xlim} and \code{ylim} of the plot can be reduced by submitting parameters \code{tpr.stop}  and \code{fpr.stop} with values <1.
}
\examples{
# Benchmark and plot one networks on the whole set of test GSs, using no mask:
data(can.sig.go);
fpath <- can.sig.go
gs.list <- import.gs(fpath, Lowercase = 1, col.gene = 2, col.set = 3);
data(net.kegg)
netpath <- net.kegg
net <- import.net(netpath)
\donttest{
b0 <- benchmark (NET = net,
 GS = gs.list,
 echo=1, graph=TRUE, na.replace = 0, mask = ".", minN = 0,
 coff.z = 1.965, coff.fdr = 0.1, Parallelize=2);
 roc(b0, coff.z = 1.64);
}
\dontrun{
## Benchmark and plot a number of networks on GO terms and KEGG pathways separately, using masks
b1 <- NULL;
for (mask in c("kegg_", "go_")) {
b1[[mask]] <- NULL;
for (file.net in c("netpath")) {
# a series of networks can be put here: c("netpath1", "netpath2", "netpath3")
net <- import.net(netpath, col.1 = 1, col.2 = 2, Lowercase = 1, echo = 1)
b1[[mask]][[file.net]] <- benchmark (NET = net, GS = gs.list,
gs.gene.col = 2, gs.group.col = 3, net.gene1.col = 1, net.gene2.col = 2,
echo=1, graph=FALSE, na.replace = 0, mask = mask, minN = 0, Parallelize=2);
}}
par(mfrow=c(2,1));
roc(b1[["kegg_"]], coff.z = 2.57,main="kegg_");
roc(b1[["go_"]], coff.z = 2.57,main="go_");
}

}
\references{
\url{http://www.biomedcentral.com/1471-2105/15/308}
}
\seealso{
\link{benchmark}
}
\keyword{benchmark}
