% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-gs.r
\name{import.gs}
\alias{import.gs}
\title{Read in an AGS or FGS test file}
\usage{
import.gs(tbl, Lowercase = 1, col.gene = 2, col.set = 3, gs.type = "",
  header = FALSE)
}
\arguments{
\item{tbl}{Input TAB-delimited FGS file.}

\item{Lowercase}{render gene/protein IDs lower-case.}

\item{col.gene}{Number of the column with gene/protein IDs in the input file.}

\item{col.set}{Number of the column with set (sample, pathway etc.) IDs in the input file.
Special options:
\code{col.set = 0}: all gene/protein IDs in the file become members of a single FGS;
\code{col.set < 0} each single gene/protein IDs becomes a separate FGS (ID of which equals the gene/protein ID).}

\item{gs.type}{GS type, 'a' produces AGS, 'f' produces FGS.}

\item{header}{assign logical value (TRUE/FALSE) to consider the first line as header from the input file (default:FALSE).}
}
\value{
A list with entry names that correspond AGS/FGS IDs in the input file and gene/protein IDs as elements of each entry.
}
\description{
Imports a TAB-delimited AGS or FGS file.
Checks the format of the given FGS file. Reads in unique gene/protein IDs from the given file \code{tbl} so that the created object can be directly submitted to \code{\link{nea.render}} and \code{\link{gsea.render}}. The function \code{import.gs} will be automatically called from \code{\link{nea.render}} if parameters \code{AGS} and/or \code{FGS} of the latter correspond to text files rather than lists.
}
\examples{
data(can.sig.go)
fpath <- can.sig.go
fgs.list <- import.gs(fpath)
summary(fgs.list)

}
\seealso{
\code{\link{mutations2ags}}, \link{samples2ags}
}
