% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{prv}
\alias{prv}
\title{Output variable states within functions/loops during testing/debugging}
\usage{
prv(..., counts = NULL)
}
\arguments{
\item{...}{series of variable(s) to report, separated by commas, which will trigger
automatic labelling of the variable name}

\item{counts}{a list of array index values; so if calling during a counting loop, the
value can be reported each iteration, also printing the count index; if the list is
named the name will also appear, e.g, variable[count=1]. This list must be the same
length as the variable list ... , and each element [[i]] must contain as many values
as the original corresponding variable list[i] has dimensions}
}
\description{
Same as preview but no labels command, and input is without quotes
and should be plain variable names of existing variables (no indices, args, etc)
A versatile function to compactly display most common R objects. Will
return the object name, type, dimension, and a compact representation of
object contents, for instance using prv.large() to display matrices,
so as to not overload the console for large objects. Useful for debugging,
can be placed inside loops and functions to track values, dimensions, and data types.
Particularly when debugging complex code, the automatic display of the variable name
prevents confusion versus using regular print statements.
By listing variables to track as character(), provides 'cat()' output 
of compact and informative variable state information, e.g, variable name, value,
datatype and dimension. Can also specify array or list elements, or custom labels.
prv() is the same as preview() except it can take objects without using double quotes
and has no 'labels' command (and doesn't need one). If expressions are entered rather
than variable names, then prv() will attempt to pass the arguments to preview().
prv() assumes that the variable(s) to report originate from the environment calling
prv(), and if not found there, then it will search through all accessible environments
starting with the global environment, and then will report the first instance found,
which in exceptional circumstances (be warned) may not be the instance you intended
to retrieve.
}
\examples{
# create variables of different types to show output styles #
testvar1 <- 193
testvar2 <- "Atol"
testvar3 <- c(1:10)
testvar4 <- matrix(rnorm(100),nrow=25)
testvar5 <- list(first="test",second=testvar4,third=100:110)
preview("testvar1"); prv(testvar1)
prv(testvar1,testvar2,testvar3,testvar4)
prv(matrix(rnorm(100),nrow=25)) # expression sent to preview() with no label
prv(193) # fails as there are no object names involved
}
\seealso{
\code{\link{Dim}}
}

