\name{result}
\alias{result}
\docType{data}
\title{
Jurkat T-cell transcritomic data with isoforms 
selected by NBBttest
}
\description{
A data  consist of 7 information columns and 6 
data (numeric) columns and 1953 RNA isoforms 
selected by NBBttest are used to make heatmaps.
}
\usage{data("result")}
\format{
A data frame with 1953 observations on the 
following 14 variables.
  \describe{
    \item{\code{tagid}}{: a numeric vector}
    \item{\code{geneid}}{: a numeric vector}
    \item{\code{name}}{: a string vector}
    \item{\code{chr}}{: a string vector, a set of 24 chrosomomes}
    \item{\code{strand}}{: a factor with levels \code{-} \code{+}}
    \item{\code{pos}}{: a numeric vector}
    \item{\code{anno}}{: string vector, poly(A) site types}
    \item{\code{Jurk.NS.A}}{: a numeric vector}
    \item{\code{Jurk.NS.B}}{: a numeric vector}
    \item{\code{Jurk.NS.C}}{: a numeric vector}
    \item{\code{Jurk.48h.A}}{: a numeric vector}
    \item{\code{Jurk.48h.B}}{: a numeric vector}
    \item{\code{Jurk.48h.C}}{: a numeric vector}
    \item{\code{tvalue}}{: a numeric vector}
  }
}
\details{
The original data are count data generated by next 
generation sequencing from Jurkat T-cells. This 
dataset is a short dataset containing 1953 isoforms 
that show differential expression between rest 
status and stimulation status. The T-cells were 
treated by resting and stimulating with \emph{CD3/CD28} 
for 48 hours. The data have 7 columns for the information 
of \emph{poly(A)} site: "tagid", "geneid", "gene name", 
"chromosome", "strand",\emph{poly(A)} site position, 
\emph{poly(A)} site annotation and 6 columns for 
data: Jurk.NS.A, Jurk.NS.B, Jurk.NS.C,	Jurk.48h.A,	
Jurk.48h.B,	Jurk.48h.C. where NS means Normal state 
or no stimulation and 48h means 48 hours after 
\emph{CD3/CD28} stimulatuin of T-cells. 13409 
\emph{RNA} isoforms were detected to have alternative 
\emph{poly(A)} sites.
}

\value{
datasheet containd	ID, information, count data of RNA 
reads.
	}

\references{
Yuan-De Tan Anita M. Chandler, Arindam Chaudhury, and 
Joel R. Neilson(2015) A Powerful Statistical Approach 
for Large-scale Differential Transcription Analysis.
\emph{Plos One}. DOI: 10.1371/journal.pone.0123658. 
}
\examples{
data(result)
}
\keyword{datasets}
