/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import net.myrrix.web.servlets.PreferenceServlet;
import org.apache.mahout.cf.taste.common.TasteException;

public final class TagItemServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        float tagValue;
        String itemTag;
        long itemID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            itemID = Long.parseLong(pathComponents.next());
            itemTag = pathComponents.next();
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        try {
            tagValue = PreferenceServlet.readValue(request);
        }
        catch (IllegalArgumentException ignored) {
            response.sendError(400, "Bad value");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            recommender.setItemTag(itemTag, itemID, tagValue);
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
    }
}

