% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distancia.R
\name{Distancia}
\alias{Distancia}
\title{Distancia de dissimilaridade}
\usage{
Distancia(Dados,Metodo,Cov=NULL)
}
\arguments{
\item{Dados}{Matriz contendo os dados para calculo das distancias. Nas
linhas devem estar os tratamentos, e nas colunas as variaveis respostas.
Neste arquivo nao deve ter a identificacao dos tratamentos.}

\item{Metodo}{Valor numerico indicando o metodo a ser utilizado:
\itemize{
 \item  Dados quantitativos

 \itemize{
 \item 1 = Distancia euclidiana.
 \item  2= Distancia euclidiana media.
  \item 3 = Quadrado da distancia euclidiana media.
  \item 4 = Distancia euclidiana padronizada.
  \item 5 = Distancia euclidiana padronizada media.
  \item 6 = Quadrado da distancia euclidiana padronizada media.
  \item 7 = Distancia de Mahalanobis.
  \item 8 = Distancia de Cole Rodgers.
  }

  \item Dados qualitativos: binarios ou multicategoricos
  \itemize{
  \item 9 = Frequencia de coincidencia.
  \item 10 = Frequencia de discordancia.
  \item 11 = indice Inverso de 1+coincidencia = 1/(1+c)
  }

  \item Dados qualitativos binarios
  \itemize{
 \item 12 = Dissimilaridade de Jacard: 1-a/(a+b+c).
  \item 13 = Dissimilaridade de Sorensen Dice: 1-2a/(2a+b+c).
  \item 14 = Dissimilaridade de Sokal e Sneath: 1-2(a+d)/(2(a+d)+b+c)
  \item 15 = Dissimilaridade de Roger e Tanimoto: 1-(a+d)/(a+2(b+c)+d)
  \item 16 = Dissimilaridade de Russel e Rao: 1-a/(a+b+c+d).
  \item 17 = Dissimilaridade de Ochiai: 1-a/sqrt((a+b)(a+c)).
  \item 18 = Dissimilaridade de Ochiai II: 1-ab/sqrt((a+b)(a+c)(b+d)(c+d)).
  \item 19 = Dissimilaridade de Haman: 1-((a+d)-(b+c))/(a+b+c+d).
  \item 20 = Dissimilaridade de Yule: 1-(ad-bc)/(ad+bc).
  }

  \item Dados mistos
  \itemize{
  \item  21 =Dissimilaridade de Gower
  }
  }}

\item{Cov}{matriz quadrada e simetrica contendo as variancias e
covariancias (residuais) entre as caracteristicas. Necessaria apenas para
calculo da distancia de Mahalanobis.}
}
\value{
A funcao retorna a distancia estimada entre os tratamentos.
}
\description{
Esta funcao retorna a distancia de dissimilaridade.
}
\examples{
data(Dados.MED)
##########> Dados quantitativos
#1 = Distancia euclidiana.
Distancia(Dados.MED,1)
#2 = Distancia euclidiana media.
Distancia(Dados.MED,2)
#3 = Quadrado da distancia euclidiana media.
Distancia(Dados.MED,3)
#4 = Distancia euclidiana padronizada.
Distancia(Dados.MED,4)
#5 = Distancia euclidiana padronizada media.
Distancia(Dados.MED,5)
#6 = Quadrado da distancia euclidiana padronizada media (Dados Quantitativos)".
Distancia(Dados.MED,6)
#7 = Distancia de Mahalanobis.
data(Dados.DBC)
m=MANOVA(Dados.DBC,2)
Med=apply(Dados.DBC[, -c(1:2)],2,function(x) tapply(x,as.factor(Dados.DBC[,1]),mean))
CRE=m$CovarianciaResidual
Distancia(Med,7,CRE)
#8 = Distancia de Cole Rodgers.
Distancia(Dados.MED,8)

######################>Dados qualitativos: binarios ou multicategoricos
#9 = Frequencia de coincidencia.
data(Dados.CAT)
Distancia(Dados.CAT,9)
#10 = Frequencia de discordancia.
Distancia(Dados.CAT,10)
data(Dados.BIN)
Distancia(Dados.BIN,10)
#11 = indice Inverso de 1+coincidencia  > 1/(1+c)
Distancia(Dados.CAT,11)

##############################>Dados qualitativos binarios
data(Dados.BIN)
#12 = Dissimilaridade de Jacard.
Distancia(Dados.BIN,12)
#13 = Dissimilaridade de Sorensen Dice.
Distancia(Dados.BIN,13)
  # 14 = Dissimilaridade de Sokal e Sneath: 1-2(a+d)/(2(a+d)+b+c)
  Distancia(Dados.BIN,14)
  #15 = Dissimilaridade de Roger e Tanimoto: 1-(a+d)/(a+2(b+c)+d)
  Distancia(Dados.BIN,15)
  #16 = Dissimilaridade de Russel e Rao: 1-a/(a+b+c+d).
  Distancia(Dados.BIN,16)
  #17 = Dissimilaridade de Ochiai: 1-a/sqrt((a+b)(a+c)).
  Distancia(Dados.BIN,17)
  #18 = Dissimilaridade de Ochiai II: 1-ab/sqrt((a+b)(a+c)(b+d)(c+d)).
  Distancia(Dados.BIN,18)
  #19 = Dissimilaridade de Haman: 1-((a+d)-(b+c))/(a+b+c+d).
  Distancia(Dados.BIN,19)
  #20 = Dissimilaridade de Yule: 1-(ad-bc)/(ad+bc).
  Distancia(Dados.BIN,20)

#' ##################>Dados mistos (quantitativos, binarios e multicategoricos)
  data(Dados.Misto)
  Distancia(Dados.Misto,21)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
/code{/link{dist}/}
}
