% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSR.R
\name{CSR_plot}
\alias{CSR_plot}
\title{Create a ternary plot of CSR strategies}
\usage{
CSR_plot(
  data,
  point_size = 3,
  point_shape = 21,
  expand_margin = 1,
  custom_colors = c("#57C4AD", "#E6E1BC", "#EDA348", "#006165", "#F8E3EF", "#FFFF99",
    "#376CB1", "#B2589B", "#DC4325", "#F16C4E", "#85B97B", "#FCEB2D", "#04A89E",
    "#F49320", "#8F88C1", "#33B5D9", "#440153", "#B29BBD", "#28C865")
)
}
\arguments{
\item{data}{A dataframe containing required columns: C, S, R (numeric values between 0-1)
and type (categorical classification)}

\item{point_size}{Numeric, diameter of plot points (default = 3)}

\item{point_shape}{Numeric, symbol code for data points (default = 21, circle with border)}

\item{expand_margin}{Numeric, coefficient for plot margin expansion (default = 1)}

\item{custom_colors}{Character vector specifying hex color codes for categorical types}
}
\value{
A ggplot object representing the ternary plot of CSR strategies.
}
\description{
This function creates a ternary plot of Competition-Stress-Ruderal (CSR) strategies using the ggtern package.
}
\details{
This function implements:
\itemize{
\item Configurable point attributes (size, shape)
\item Adjustable plot boundaries
\item User-defined color schemes for categories
\item Automated legend column optimization
\item Standardized legend positioning
\item Reference grid and directional indicators
}
}
\examples{
data(PFF)
head(PFF)
traits <- data.frame(LA=PFF$Leaf_area, LDMC=PFF$LDMC, SLA=PFF$SLA)
head(traits)
result <- CSR(data = traits)
head(result)
CSR_plot(data=result)

}
\references{
\enumerate{
\item Grime, J.P. (1974). Vegetation classification by reference to strategies. Nature, 250, 26–31.
\item Pierce, S., Negreiros, D., Cerabolini, B.E.L., Kattge, J., Díaz, S., et al. (2017). A global method for calculating plant CSR ecological strategies applied across biomes world-wide. Funct Ecol, 31: 444-457.
}
}
