% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_Commutator_Kmn}
\alias{indx_Commutator_Kmn}
\title{Index vector for commutation of T-products of two vectors}
\usage{
indx_Commutator_Kmn(m, n)
}
\arguments{
\item{m}{Row-dimension}

\item{n}{Col-dimension}
}
\value{
A vector of indexes to provide the commutation
}
\description{
Transforms vec A to vec of the transposed A. Same results as matr_Commutator_Kmn.
}
\examples{
A<-1:6
A[indx_Commutator_Kmn(3,2)]
## Same as
as.vector(matr_Commutator_Kmn(3,2)\%*\%A)

}
\references{
Gy. Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 (p.8, (1.12)).
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
