% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{matr_Commutator_Moment}
\alias{matr_Commutator_Moment}
\title{Commutator matrix for moment formulae}
\usage{
matr_Commutator_Moment(el_rm, d, useSparse = FALSE)
}
\arguments{
\item{el_rm}{type of a partition}

\item{d}{dimensions of the vector}

\item{useSparse}{TRUE or FALSE}
}
\value{
A commutator matrix
}
\description{
Commutator matrix for moment formulae
}
\examples{
n=4;  r=2 ;  m=1 ;  d=2;
PTA<-Partition_Type_All(n)
el_r<-PTA$eL_r[[r]][m,]
## el_r is a given type (always a vector)
MC<- matr_Commutator_Moment(el_r,d)
MC
}
\references{
Gy., Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, Section 2.4.3, p.100, Sect. A.2.1, p. 353.,
Corollary 2.6., p.95
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
