% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_uSPA.R
\name{Test_uSPA}
\alias{Test_uSPA}
\title{Test uniform Superior Predictive Ability}
\usage{
Test_uSPA(LossDiff, L, B = 999)
}
\arguments{
\item{LossDiff}{the T x H matrix forecast path loss differential}

\item{L}{the parameter for the moving block bootstrap}

\item{B}{integer, the number of bootstrap iterations. Default 999}
}
\value{
A list containing two objects:
\item{"p_value"}{the p-value for uSPA}
\item{"t_uSPA"}{the statistics for uSPA}
}
\description{
Implements the test for uniform Superior Predictive Ability (uSPA) of Quaedvlieg (2021)
}
\examples{
## Test for uSPA
data(LossDiff_uSPA)
Test_uSPA(LossDiff=LossDiff_uSPA, L=3, B=10)

}
\references{
Quaedvlieg, Rogier. "Multi-horizon forecast comparison." Journal of Business & Economic Statistics 39.1 (2021): 40-53.
}
\seealso{
\code{\link{Test_aSPA}}
}
\author{
Luca Barbaglia \url{https://lucabarbaglia.github.io/}
}
