% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{TPDecompGraph}
\alias{TPDecompGraph}
\title{Term Premia decomposition graphs for all models}
\usage{
TPDecompGraph(
  ModelType,
  NumOut,
  ModelPara,
  WishRPgraphs,
  UnitYields,
  Economies,
  PathsGraphs,
  Folder2Save,
  verbose
)
}
\arguments{
\item{ModelType}{character. Estimated model type. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{NumOut}{list. Computed outputs containing model fit, IRFs, FEVDs, GIRFs, GFEVDs and risk premia.}

\item{ModelPara}{list. Model parameter estimates (see \code{\link{Optimization}}).}

\item{WishRPgraphs}{logical. Set TRUE to generate term premia graphs, FALSE otherwise.}

\item{UnitYields}{character. "Month" if yields are in months, "Year" if in years.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{PathsGraphs}{character. Path of the folder in which the graphs will be saved.}

\item{Folder2Save}{character. Folder path where the outputs will be stored.}

\item{verbose}{logical. Flag controlling function messaging.}
}
\description{
Term Premia decomposition graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "TermPremia")`
}

\examples{
data("ParaSetEx")
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
UnitYields <- "Month"
TPDecompGraph(ModelType, NumOutEx, ParaSetEx,
  WishRPgraphs = FALSE, UnitYields, Economy,
  PathsGraphs = NULL, Folder2Save = NULL, verbose = FALSE
)

}
