% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimization.R
\name{Optimization}
\alias{Optimization}
\title{Perform the optimization of the log-likelihood function of the chosen ATSM}
\usage{
Optimization(
  MLEinputs,
  StatQ,
  DataFreq,
  FactorLabels,
  Economies,
  ModelType,
  tol = 1e-04,
  TimeCount = TRUE,
  BS_outputs = FALSE
)
}
\arguments{
\item{MLEinputs}{A list containing the necessary inputs for building the log-likelihood function (see \code{\link{InputsForOpt}} function).}

\item{StatQ}{A binary variable (1 or 0) indicating whether to impose that the largest eigenvalue under Q is strictly
smaller than 1. Set to 1 to impose the restriction, or 0 otherwise.}

\item{DataFreq}{A character vector specifying the data frequency. Available options: "Daily All Days", "Daily Business Days",
"Weekly", "Monthly", "Quarterly", "Annually".}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{tol}{Convergence tolerance (scalar). The default is 1e-4.}

\item{TimeCount}{Logical. If TRUE, computes the time required for model estimation. Default is TRUE.}

\item{BS_outputs}{Logical. If TRUE, generates a simplified output list in the bootstrap setting. Default is FALSE.}
}
\value{
An extensive list containing model outputs after the optimization of the chosen ATSM specification.
}
\description{
Perform the optimization of the log-likelihood function of the chosen ATSM
}
\examples{
# See examples in the vignette file of this package (Section 4).

}
\references{
This function is partially adapted from the \code{LS__opt} function by Le and Singleton (2018). \cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
