% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimization.R
\name{Optimization_PE}
\alias{Optimization_PE}
\title{Peform the minimization of mean(f)}
\usage{
Optimization_PE(
  f,
  varargin,
  FactorLabels,
  Economies,
  ModelType,
  JLLinputs = NULL,
  GVARinputs = NULL,
  tol = 1e-04,
  TimeCount = TRUE
)
}
\arguments{
\item{f}{vector-valued objective function (function)}

\item{varargin}{list contain starting values and constraints:
                       for each input argument K (of f), we need four inputs that look like:
   \enumerate{
       \item a starting value: K0
       \item a variable label ('K0') followed by a ':' followed by a type of constraint. The constraint can be:
                 \itemize{
                     \item 'bounded': bounded matrix;
                     \item 'Jordan' or 'Jordan MultiCountry': a matrix of Jordan type;
                     \item 'psd': psd matrix;
                     \item 'stationary': largest eigenvalue of the risk-neutral feedback matrix is strictly smaller than 1;
                     \item 'diag' or 'BlockDiag': a diagonal or block diagonal matrix.
                     \item 'JLLstructure': to impose the zero-restrictions on the variance-variance matrix along
                             the lines of the JLL models
                         }
       \item a lower bound lb (lb <- NULL -> no lower bound)
       \item an upper bound ub (ub <- NULL -> no upper bound)
       \item Specification of the optimization settings:
       \itemize{
                 \item 'iter off': hide the printouts of the numerical optimization routines;
                 \item 'fminunc only': only uses fminunc for the optimization;
                 \item ''fminsearch only': only uses fminsearch for the optimization.

  }
  }}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{JLLinputs}{List. Inputs for JLL model estimation (see \code{JLL}). Default is NULL.}

\item{GVARinputs}{List. Inputs for GVAR model estimation (see \code{GVAR}). Default is NULL.}

\item{tol}{convergence tolerance (scalar). Default value is 1e-4.}

\item{TimeCount}{computes the required time for estimation of the model. Default is TRUE.}
}
\description{
Peform the minimization of mean(f)
}
\examples{
#' # See an example of implementation in the vignette file of this package (Section 4).


}
\references{
This function is a conceptually based on the "LS__opt" function by Le and Singleton (2018). \cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
\keyword{internal}
