\name{BootstrapDistance}
\alias{BootstrapDistance}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Bootstrap on the distance matrices used for Principal Coordinates Analysis (PCoA)
}
\description{
Obtains bootstrap replicates of a distance matrix using ramdom samples or permuatations of the residual matrix from a Principal Coordinates (Components) Analysis. The object is to estimate the sampling variability of absorbed variances, coordinates and qualities of representation in a PCoA. 
}
\usage{
BootstrapDistance(D, W=diag(nrow(D)), nB=200, dimsol=2, 
                  ProcrustesRot=TRUE, method=c("Sampling", "Permutation"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{D}{
A distance matrix
}
  \item{W}{
A diagonal matrix containing waiths for the rows of D
}
  \item{nB}{
Number of Bootstrap replications
}
  \item{dimsol}{
Dimension of the solution
}
  \item{ProcrustesRot}{
Should each replication be rotated to match the initial solution?
}
  \item{method}{
The replications are obtained "Sampling" or "Permutating" the residuals.
}

}
\details{
The function calculates bootstrap confidence intervals for the inertia, coordinates and qualties of representation of a Principal Coordinates Analysis using a distance matrix as a basis. The funcion uses random sampling or permutations of the residuals to obtain the bootstrap replications. The procedure preserves the length of the points in the multidimensional space perturbating only the angles among the vectors. It is done so to preserve the property of positiveness of the diagonal elements of the scalar product matrices. The procedure may result into a scalar product that does not have an euclidean configuration and then has some negative eigenvalues; to avoid this problem the negative eigenvalues are removed to approximate the perturbated matrix by the closest with the required properties.

It is well known that the eigenvectors of a matrix are unique except for reflections, that is, if we change the sign of each component of the eigenvector we have the same solution. If that happens, an unwanted increase in the variability due to this artifact may invalidate the results. To avoid this we can calculate the scalar product of each eigenvector of the initial matrix with the corresponding eigenvector of the bootstrap replicate and change the signs of the later if the result is negative.

Another artifact of the procedure may arise when the dimension of the solution is higher than 1 because the eigenvectors of a replicate may generate the same subspace although are not in the same directions, i. e., the subspace is referred to a different system. That also may produce an unwanted increase of the variability that invalidates the results. To avoid this, every replicate may be rotated to match as much as possible the subspace generated by the eigenvectors of the initial matrix. This is done by Procrustes Analysis, taking the rotated matrix as solution. 
The solution to this problem is also a sulution to the reflection, then only this problem is considered.
}
\value{
Returns an object of class "PCoABootstrap" with the information for each bootstrap replication.
  \item{Eigenvalues}{A matrix with dimensions in rows and replicates in columns containing the eigenvalues of each replicate in columns}
  \item{Inertias}{A matrix with dimensions in rows and replicates in columns containing the inertias of each replicate in columns}
  \item{Coordinates}{A list with a component for each object. A component contains the coordinates of an object for each replicate (in columns)}
  \item{Values-Table}{A list with a component for each object. A component contains the qualities of an object for each replicate (in columns)}
  \item{NReplicates}{Number of bootstrap replicates}
}
\references{
Efron, B.; Tibshirani, RJ. (1993). An introduction to the bootstrap. New York: Chapman and Hall. 436p.

Ringrose, T. J. (1992). Bootstrapping and correspondence analysis in archaeology. Journal of Archaeological Science, 19(6), 615-629.

MILAN, L., & WHITTAKER, J. (1995). Application of the parametric bootstrap to models that incorporate a singular value decomposition. Applied statistics, 44(1), 31-49.
}
\author{
Jose L. Vicente-Villardon
}

\seealso{
\code{\link{BootstrapScalar}}, ~~~
}
\examples{
\donttest{data(spiders)
D=BinaryProximities(spiders, coefficient="Jaccard", transformation="sqrt(1-S)")
DB=BootstrapDistance(D$Proximities)}
}
