% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.setDimInfo}
\alias{mT.setDimInfo}
\title{Set additional information (year, description, type of risk, sex, etc.) for the mortality table.}
\usage{
mT.setDimInfo(tbl, ..., append = TRUE)
}
\arguments{
\item{tbl}{The \code{mortalityTable} object to assign dimensional information}

\item{...}{The dimensional information as named arguments. All names except tbl and append are allowed.}

\item{append}{Whether to append to existing dimensional data (append=TRUE) or
completely replace existing information (append=FALSE)}
}
\description{
A mortalityTable can store additional information to be used e.g. as additional
dimensions in ggplot calls. Typically, these information include sex, base
population, observation year, type of data (raw, smoothed), country, type of
risk, etc. These additional dimensions are stored in the \code{tbl@data} list
and will be used by plotMortalityTables and similar functions.
}
\examples{
mortalityTables.load("Austria_Census")
mortalityTables.load("Austria_Annuities")
# The annuity tables use the population mortality as starting point. Set either
# population or anuuitants as dimensional info and use that dimension in a ggplot
# Most pre-defined tables already have the most important dimensions (like sex) stored.
at01.m = mT.setDimInfo(mort.AT.census.2001.male, population = "Population")
at01.f = mT.setDimInfo(mort.AT.census.2001.female, population = "Population")
av05r.m = mT.setDimInfo(AVOe2005R.male, population = "Annuitants")
plotMortalityTables(at01.m, at01.f, av05r.m) + aes(linetype = population, color = sex)
}
