# --------------------------------------------------- #
# Author: Marius D. PASCARIU
# Last update: Sun May 02 17:23:31 2021
# --------------------------------------------------- #

#' MortalityLaws Test Data
#'
#' Dataset containing altered death rates (mx), death counts (Dx)
#' and exposures (Ex) for the female population living in
#' England & Wales in four different years: 1850, 1900, 1950 and 2010.
#' The data-set is provided for testing purposes only.
#' Download the actual data free of charge from \url{https://www.mortality.org}.
#' Once a username and a password are created on the website the function
#' \code{\link{ReadHMD}} can be used for downloading.
#'
#' @source \href{https://www.mortality.org}{Human Mortality Database}
#' @seealso \code{\link{ReadHMD}}
#' @examples head(ahmd$mx)
"ahmd"


#' HMD sample
#' Data object generated by the \code{ReadHMD()} function.
#' @keywords internal
"HMD_sample"

#' AHMD sample
#' Data object generated by the \code{ReadAHMD()} function.
#' @keywords internal
"AHMD_sample"

#' CHMD sample
#' Data object generated by the \code{ReadCHMD()} function.
#' @keywords internal
"CHMD_sample"

#' JMD sample
#' Data object generated by the \code{ReadJMD()} function.
#' @keywords internal
"JMD_sample"


