% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MortalityLaw_S3.R
\name{predict.MortalityLaw}
\alias{predict.MortalityLaw}
\title{Predict function for MortalityLaw}
\usage{
\method{predict}{MortalityLaw}(object, x, ...)
}
\arguments{
\item{object}{An object of class \code{"MortalityLaw"}}

\item{x}{Vector of ages to be considered in prediction}

\item{...}{Additional arguments affecting the predictions produced.}
}
\description{
Predict function for MortalityLaw
}
\examples{
# Extrapolate old-age mortality with the Kannisto model
# Fit ages 80-94 and extrapolate up to 120.

Mx <- ahmd$mx[paste(80:94), "1950"]
M1 <- MortalityLaw(x = 80:94, mx  = Mx, law = 'kannisto', scale.x = TRUE)
fitted(M1)
predict(M1, x = 80:120)

# See more examples in MortalityLaw function help page.
}
\seealso{
\code{\link{MortalityLaw}}
}
