# Data in the package.

#' England and Wales Demographic Data
#'
#' Dataset containing altered death rates (mx), death counts (Dx) 
#' and exposures (Ex) for female population living in 
#' England & Wales in four different years: 1850, 1900, 1950 and 2010. 
#' The data-set is provided for testing purposes only.
#' Download the actual data free of charge from \url{http://www.mortality.org}.
#' Once a username and a password is created on the website the function
#' \code{\link{ReadHMD}} can be used for downloading.
#' 
#' @source \href{http://www.mortality.org}{Human Mortality Database}  
#' @seealso \code{\link{ReadHMD}}
#' @examples head(ahmd$mx) 
"ahmd"


# Imports -----

#' @import graphics
#' @importFrom RCurl getURL
#' @importFrom utils read.table head tail
#' @importFrom stats fitted coef optim predict quantile
#' @importFrom pbapply startpb closepb setpb
NULL
