% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disp.r
\name{disp}
\alias{disp}
\title{Generate a grid layout for panel plots}
\usage{
disp(n, horiz = FALSE)
}
\arguments{
\item{n}{number of plots to be displayed}

\item{horiz}{should horizontal growth be favored instead of vertical (default)}
}
\value{
disp returns a vector of length two that indicates the number of rows and columns to be passed to \code{par(mfrow)}.
}
\description{
For a given number of plots to be displayed in a panel, this function suggests inputs for the \code{par(mfrow)} graphic option.
}
\details{
This simple function is designed to generate the "squarest" layout grid given the number of plots to be displayed in the same panel.
If \code{n} has an integer square root, the dimensions are simply \code{sqrt(n) x sqrt(n)}. Otherwise, the function starts from the next smaller square grid and adds progressively more rows.
}
\examples{
# Example with a random number of plots
n <- sample(2:16, 1)
par(mfrow = disp(n), mar = c(2,2,2,2))
for(i in 1:n){
  plot(rnorm(100),rnorm(100))
}
par(mfrow = c(1,1), mar = c(5,4,4,2) + .1)

# Display grid for up to 20 plots
par(mfrow = disp(20), mar = c(2,2,2,2))
for(i in 1:20){
  mat <- matrix(NA,nrow = disp(i)[1], ncol = disp(i)[2])
  image(mat, axes = FALSE, main = i)
  grid(nx = disp(i)[1], ny = disp(i)[2], col = 1)
  box()
}
par(mfrow = c(1,1), mar = c(5,4,4,2) + .1)



}
