% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axSchoen.R
\name{axSchoen}
\alias{axSchoen}
\title{axSchoen Schoen's MDAT approximation of Chiang's a(x), average number of years lived by persons dying in the interval x, x + n.}
\usage{
axSchoen(Mx, n, axsmooth = TRUE)
}
\arguments{
\item{Mx}{a numeric vector of the age-specific central death rates, calculated as D(x)/N(x) (deaths/exposure)}

\item{n}{a numeric vector of age interval widths.}

\item{axsmooth}{logical. default = \code{TRUE}. Should the a(x) values be calculated from a smoothed M(x) series? In this case, the M(x) series is smoothed within the function for a(x) estimation, but the smoothed M(x) function that was used is not returned. In general, it is better to smooth the M(x) function prior to putting it in this function, because the loess smoother used here has no weights or offset. If this is not possible, loess M(x) smoothing still produces more consistent and less erratic a(x) estimates.}
}
\description{
This estimation technique of Chiang's a(x) was proposed by Schoen (1978) and is called the Mean Duration at Transfer (MDAT) method. Adjacent values of the force of mortality function, M(x), assumed to be the lifetable m(x), are used to estimate the mean age at exit from each interval.
}
\details{
The very last a(x) value is imputed using linear extrapolation of the prior 3 points. For most demographic measures, precision at the upper ages has little or no effect on results. In general, this estimation procedure works very well, and produces results very similar to the Keyfitz iterative procedure, but the estimates at the final ages tend to turn upward, where they ought to slope downward instead.
}
\references{
Chiang C.L.(1968) Introduction to Stochastic Processes in Biostatistics. New York: Wiley.

Schoen R. (1978) Calculating lifetables by estimating Chiang's a from observed rates. Demography 15: 625-35.

Preston et al (2001) Demography: Measuring and Modeling Population Processes. Malden MA: Blackwell.
}
\seealso{
See Also as \code{\link{axEstimate}}, a wrapper function for this and three other a(x) estimation procedures (\code{\link{axMidpoint}}, \code{\link{axKeyfitz}} and \code{\link{axPreston}}).
}
\author{
Tim Riffe
}
