% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_methods.R
\name{mlt}
\alias{mlt}
\alias{mltj}
\title{Model Life Tables Mortality Patterns}
\usage{
mlt(e0, sex = c("male", "female"), type = "CD_West", nx = 5, ...)

mltj(e0m, e0f, ..., nx = 5)
}
\arguments{
\item{e0}{A time series of target life expectancy.}

\item{sex}{Either "male" or "female".}

\item{type}{Type of the model life table. Available options are \dQuote{CD_East}, \dQuote{CD_North}, 
\dQuote{CD_South}, \dQuote{CD_West}, \dQuote{UN_Chilean}, \dQuote{UN_Far_Eastern}, 
\dQuote{UN_General}, \dQuote{UN_Latin_American}, \dQuote{UN_South_Asian}.}

\item{nx}{Size of age groups. Should be either 5 or 1.}

\item{\dots}{Additional arguments passed to the underlying function.}

\item{e0m}{A time series of target male life expectancy.}

\item{e0f}{A time series of target female life expectancy.}
}
\value{
Function \code{mlt} returns a matrix with the predicted mortality rates. Columns correspond 
    to the values in the \code{e0} vector and rows correspond to age groups. 
    Function \code{mltj} returns a list of such matrices, one for each sex.
}
\description{
Predict age-specific mortality rates using Coale-Demeny and UN model life tables.
}
\details{
Given a level of life expectancy (e0), sex and a type of model life table, the function 
    extracts the corresponding mortality pattern from \code{\link{MLTlookup}} (for abridged LT) 
    or \code{\link{MLT1Ylookup}} (for 1-year LT), 
    while interpolating between neighboring e0 groups.
    Function \code{mlt} is for one sex, while \code{mltj} can be used for both sexes.
}
\examples{
data(e0Fproj, package = "wpp2017")
country <- "Uganda"
# get target e0
e0f <- subset(e0Fproj, name == country)[-(1:2)]
# project into future using life table Cole-Demeny North
mx <- mlt(e0f, sex = "female", type = "CD_North")
# plot first projection in black and the remaining ones in grey 
plot(mx[,1], type = "l", log = "y", ylim = range(mx),
    ylab = "female mx", xlab = "Age", 
    main = paste(country, "5-year age groups"))
for(i in 2:ncol(mx)) lines(mx[,i], col = "grey")

# MLT for 1-year age groups
mx1y <- mlt(e0f, sex = "female", type = "CD_North", nx = 1)
plot(mx1y[,1], type = "l", log = "y", ylim = range(mx1y),
    ylab = "female mx", xlab = "Age", 
    main = paste(country, "1-year age groups"))
for(i in 2:ncol(mx1y)) lines(mx1y[,i], col = "grey")
    
}
\references{
\url{https://www.un.org/development/desa/pd/data/extended-model-life-tables}

Coale, A., P. Demeny, and B. Vaughn. 1983. Regional model life tables and stable 
populations. 2nd ed. New York: Academic Press.
}
\seealso{
\code{\link{mortcast}}, \code{\link{mortcast.blend}}, \code{\link{pmd}}, \code{\link{MLTlookup}}
}
