% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kannisto.R
\name{cokannisto}
\alias{cokannisto}
\title{Coherent Kannisto Method}
\usage{
cokannisto(mxM, mxF, est.ages = seq(80, 95, by = 5),
  proj.ages = seq(100, 130, by = 5))
}
\arguments{
\item{mxM}{A vector or matrix of male mortality rates. If it is a matrix,
rows correspond to age groups with rownames identifying the corresponding age as integers.
By default five-years age groups are assigned to rows if rownames are not given.}

\item{mxF}{A vector or matrix of female mortality rates. Its length or dimension 
should be the same \code{mxM}.}

\item{est.ages}{A vector of integers identifying the ages to be used 
for estimation. It should be a subset of rownames of \code{mxM}.}

\item{proj.ages}{A vector of integers identifying the age groups for which mortality rates 
are to be projected.}
}
\value{
A list of two vectors or matrices (for male and female) containing the input motality 
   objects extended by the extrapolated age groups.
}
\description{
Extrapolate given mortality rates into higher ages 
    using the Coherent Kannisto method as described in Sevcikova et al. (2016).
}
\details{
The function first estimates the coherent Kannisto parameters 
    by passing mortality rates for age groups \code{est.ages} into 
    the \code{\link{cokannisto.estimate}} function.
    The estimated parameters are then passed to the projection function
    \code{\link{kannisto.predict}} to extrapolate into ages \code{proj.ages}.
    Lastly, the input mortality objects are extended by results for the extrapolated ages. 
    If \code{proj.ages} contains age groups that are included in \code{mxM} and \code{mxF},
    values for those age groups are overwritten.
}
\examples{
data(mxM, mxF, package = "wpp2017")
country <- "South Africa"
mxm <- subset(mxM, name == country)[,-(1:3)]
mxf <- subset(mxF, name == country)[,-(1:3)]
rownames(mxm) <- rownames(mxf) <- c(0,1, seq(5, 100, by=5))
mxnew <- cokannisto(mxm, mxf)
ages <- as.integer(rownames(mxnew$male))
plot(ages, mxnew$male[,"2095-2100"], type="l", log="y", 
    xlab="age", ylab="mx", col="blue", main=country)
lines(ages, mxnew$female[,"2095-2100"], col="red")
lines(ages, mxnew$male[,"2010-2015"], lty=2, col="blue")
lines(ages, mxnew$female[,"2010-2015"], lty=2, col="red")
legend("bottomright", legend=c("male 2010-2015", "female 2010-2015",
    "male 2095-2100", "female 2095-2100"), bty="n",
    col=rep(c("blue", "red"),2), lty=c(2,2,1,1))

}
\references{
Sevcikova H., Li N., Kantorova V., Gerland P., Raftery A.E. (2016). 
Age-Specific Mortality and Fertility Rates for Probabilistic Population Projections. 
In: Schoen R. (eds) Dynamic Demographic Analysis. The Springer Series on Demographic Methods
and Population Analysis, vol 39. Springer, Cham
}
\seealso{
\code{\link{cokannisto.estimate}}, \code{\link{kannisto.predict}}
}
