% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider2d.r
\encoding{utf8}
\name{slider2d}
\alias{slider2d}
\title{slides Semilandmarks along curves 2D by minimising bending
energy of a thin-plate spline deformation.}
\usage{
slider2d(dataframe, SMvector, outlines, tol = 1e-05, deselect = FALSE,
  recursive = TRUE, iterations = 0, initproc = FALSE,
  pairedLM = NULL, bending = TRUE, stepsize = 1, silent = FALSE)
}
\arguments{
\item{dataframe}{Input k x 2 x n real array, where k is the number of
points and n is the sample size. Ideally the}

\item{SMvector}{A vector containing the row indices of (semi-) landmarks on the curve(s) and
surfaces that are allowed to slide}

\item{outlines}{A vector (or if threre are several curves) a list of vectors
(containing the rowindices) of the (Semi-)landmarks forming the curve(s) in
the successive position on the curve - including the beginning and end
points, that are not allowed to slide.}

\item{tol}{numeric: Threshold for convergence in the sliding process}

\item{deselect}{Logical: if TRUE, the SMvector is interpreted as those
landmarks, that are not allowed to slide.}

\item{recursive}{Logical: if TRUE, during the iterations of the sliding
process, the outcome of the previous iteration will be used.  Otherwise the
original configuration will be used in all iterations.}

\item{iterations}{integer: select manually the max. number of iterations
that will be performed during the sliding process (usefull, when there is
very slow convergence).  0 means iteration until convergence.}

\item{initproc}{requests initial Procrustes fit before sliding.}

\item{pairedLM}{A X x 2 numeric matrix with the indices of the rows
containing paired Landmarks. E.g. the left column contains the lefthand
landmarks, while the right side contains the corresponding right hand
landmarks. - This will ideally create symmetric mean to get rid of
assymetry.}

\item{bending}{if TRUE, bending energy will be minimized, Procrustes distance otherwise.}

\item{stepsize}{integer: dampening factor for the amount of sliding.
Useful to keep semi-landmarks from sliding too far off the surface.
The displacement is calculated as  \eqn{\Upsilon = \Upsilon^0 + stepsize * UT}{Y = Y0 + stepsize * UT}.
Default is set to 1 for bending=TRUE and 0.5 for bending=FALSE.}

\item{silent}{logical: if TRUE, console output is suppressed.}
}
\value{
returns an array containing slided coorndinates in the original
space - not yet processed by a Procrustes analysis.
}
\description{
slides Semilandmarks along curves 2D. The positions are sought by minimising bending energy (of a thin-plate spline
deformation) or Procrustes distance
}
\section{Warning}{
 Depending on the amount of landmarks this can use an extensive amount of your PC's
resources, especially when running in parallel. As the computation time and
RAM usage of matrix algebra involved is quadratic to the amount of landmarks
used, doubling the amount of semi-landmarks will quadruple computation time
and system resource usage. You can easily stall you computer with this
function with inappropriate data.
}

\seealso{
\code{\link{relaxLM}, \link{slider3d}}
}
\author{
Stefan Schlager
}
