% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqmat.r
\name{qqmat}
\alias{qqmat}
\title{Q-Q plot to assess normality of data}
\usage{
qqmat(x, output = FALSE, square = FALSE)
}
\arguments{
\item{x}{sample data: matrix or vector}

\item{output}{logical: if TRUE results are returned}

\item{square}{plot in a square window - outliers might be cut off.}
}
\value{
if \code{output=TRUE}, the following values are returned
\item{x }{distances from an expected Gaussian distribution}
\item{y }{observed distances - sorted}
\item{d }{observed distances - unsorted}
}
\description{
qqmat plots Mahalanobisdistances of a given sample against those expected
from a Gaussian distribution
}
\examples{

require(MASS)
### create normally distributed data
data <- mvrnorm(100,mu=rep(0,5),Sigma = diag(5:1))
qqmat(data)

###create non normally distributed data
data1 <- rchisq(100,df=3)
qqmat(data1,square=FALSE)

}
\author{
Stefan Schlager
}
\seealso{
\code{\link{qqplot}}
}

