% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/retrodeform.r
\name{retroDeformMesh}
\alias{retroDeformMesh}
\title{symmetrize a triangular mesh}
\usage{
retroDeformMesh(mesh, mat, pairedLM, hmult = 5, alpha = 0.01, rot = TRUE,
  lambda = 1e-08)
}
\arguments{
\item{mesh}{triangular mesh of class mesh3d}

\item{mat}{matrix with bilateral landmarks}

\item{pairedLM}{2-column integer matrix with the 1st columns containing row indices of left side landmarks and 2nd column the right hand landmarks}

\item{hmult}{damping factor for calculating local weights}

\item{alpha}{factor controlling spacing along x-axis}

\item{rot}{logical: if TRUE the deformed landmarks are rotated back onto the original ones}

\item{lambda}{control parameter passed to \code{\link{tps3d}}}
}
\value{
\item{mesh}{symmetrized mesh}
\item{landmarks}{a list containing the deformed and original landmarks}
}
\description{
symmetrize a triangular mesh
}
\details{
this function performs \code{\link{retroDeform3d}} and deforms the mesh accordingly using the function \code{\link{tps3d}}.
}

