% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typprob.r
\name{typprob}
\alias{typprob}
\alias{typprobClass}
\title{calculate typicality probabilities}
\usage{
typprob(
  x,
  data,
  small = FALSE,
  method = c("chisquare", "wilson"),
  center = NULL,
  cova = NULL,
  robust = c("classical", "mve", "mcd"),
  ...
)

typprobClass(
  x,
  data,
  groups,
  small = FALSE,
  method = c("chisquare", "wilson"),
  outlier = 0.01,
  sep = FALSE,
  cv = TRUE,
  robust = c("classical", "mve", "mcd"),
  ...
)
}
\arguments{
\item{x}{vector or matrix of data the probability is to be calculated.}

\item{data}{Reference data set. If missing x will be used.}

\item{small}{adjustion of Mahalanobis D^2 for small sample sizes as
suggested by Wilson (1981), only takes effect when method="wilson".}

\item{method}{select method for probability estimation. Available options
are "chisquare" (or any abbreviation) or "wilson". "chisquare" exploits
simply the chisquare distribution of the mahalanobisdistance, while "wilson"
uses the methods suggested by Wilson(1981). Results will be similar in
general.}

\item{center}{vector: specify custom vector to calculate distance to. If not
defined, group mean will be used.}

\item{cova}{covariance matrix to calculate mahalanobis-distance: specify
custom covariance matrix to calculate distance.}

\item{robust}{character: determines covariance estimation methods, allowing for robust estimations using \code{MASS::cov.rob}. Default is the standard product-moment covariance matrix.}

\item{...}{additional parameters passed to \code{MASS::cov.rob} for robust covariance and mean estimations.}

\item{groups}{vector containing grouping information.}

\item{outlier}{probability threshold below which a specimen will not be
assigned to any group-}

\item{sep}{logical: if TRUE, probability will be calculated from the pooled
within group covariance matrix.}

\item{cv}{logical: if data is missing and \code{cv=TRUE}, the resulting classification will be validated by leaving-one-out crossvalidation.}
}
\value{
typprob: returns a vector of probabilities.

typprobClass:
\item{probs }{matrix of probabilities for each group}
\item{groupaffin }{vector of groups each specimen has been assigned to. Outliers are classified "none"}
\item{probsCV }{cross-validated matrix of probabilities for each group}
\item{groupaffinCV }{cross-validated vector of groups each specimen has been assigned to. Outliers are classified "none"}
\item{self }{logical: if TRUE, the data has been classified by self-inference.}
}
\description{
calculate typicality probabilities
}
\details{
get the probability for an observation belonging to a given multivariate
nromal distribution
}
\examples{

if (require(shapes)) {
data <- procSym(gorf.dat)$PCscores[,1:3]
probas <- typprob(data,data,small=TRUE)### get probability for each specimen

### now we check how this behaves compared to the mahalanobis distance
maha <- mahalanobis(data,colMeans(data),cov(data))
plot(probas,maha,xlab="Probability",ylab="Mahalanobis D^2")

data2 <- procSym(abind(gorf.dat,gorm.dat))$PCscores[,1:3]
fac <- as.factor(c(rep("female",dim(gorf.dat)[3]),rep("male",dim(gorm.dat)[3])))
typClass <- typprobClass(data2,groups=fac,method="w",small=TRUE,cv=TRUE)
## only 59 specimen is rather small.
typClass2 <- typprobClass(data2,groups=fac,method="c",cv=TRUE)## use default settings

### check results for first method:
typClass


### check results for second method:
typClass2
}

}
\references{
Albrecht G. 1992. Assessing the affinities of fossils using
canonical variates and generalized distances Human Evolution 7:49-69.

Wilson S. 1981. On comparing fossil specimens with population samples
Journal of Human Evolution 10:207 - 214.
}
\author{
Stefan Schlager
}
