\name{unrefVertex}
\alias{unrefVertex}
\alias{rmVertex}
\alias{vert2points}
\alias{rmUnrefVertex}
\title{some little helpers for vertex operations on triangular meshes
}
\description{
extract vertex coordinates from meshes, find and/or remove (unreferenced) vertices from triangular meshes}
\usage{
unrefVertex(mesh)
rmVertex(mesh, index, keep=FALSE)
vert2points(mesh)
rmUnrefVertex(mesh, silent=FALSE)

}
\arguments{
  \item{mesh }{triangular mesh of class \code{mesh3d}.
  }
  \item{index }{vector containing indices of vertices to be removed.
  }
  \item{keep }{logical: if \code{TRUE}, the vertices specified by \code{index} are
    kept and the rest is removed.
  }
  \item{silent }{logical: suppress output about info on removed
    vertices.
  }
}
\details{\code{unrefVertex} finds unreferenced vertices in triangular
  meshes of class \code{mesh3d}.
  
  \code{rmVertex} removes specified vertices from triangular meshes.
  
  \code{vert2points} extacts vertex coordinates from triangular meshes.

   \code{rmUnrefVertex} removes unreferenced vertices from triangular meshes.
}
\value{
  \code{unrefVertex}: vector with indices of unreferenced vertices.
  
  \code{rmVertex}: returns mesh with specified vertices removed and faces and
  normals updated.
  
  \code{vert2points}: k x 3 matrix containing vertex coordinates.
  
  \code{rmUnrefVertex}: mesh with unreferenced vertices removed.
  
}


\author{
Stefan Schlager}



\seealso{
 \code{\link{ply2mesh}}, \code{\link{file2mesh}} 
}
\examples{
require(rgl)
data(nose)
testmesh <- rmVertex(shortnose.mesh,1:50) ## remove first 50 vertices
shade3d(testmesh,col=3) ### view result
testmesh$vb <- cbind(testmesh$vb,shortnose.mesh$vb[,1:50]) ## add some unreferenced vertices
points3d(vert2points(testmesh),col=2)## see the vertices in the holes?

cleanmesh <- rmUnrefVertex(testmesh)## remove those lonely vertices!
rgl.pop()
points3d(vert2points(cleanmesh),col=2) ### now the holes are empty!!


}
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }
