% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-bezier.R
\name{bezier}
\alias{bezier}
\title{Calculates Bezier coefficients from a shape}
\usage{
bezier(coo, n)
}
\arguments{
\item{coo}{a matrix or a list of (x; y) coordinates}

\item{n}{the degree, by default the number of coordinates.}
}
\value{
a list with components:
\itemize{
\item \code{$J} matrix of Bezier coefficients
\item \code{$B} matrix of Bezier vertices.
}
}
\description{
Calculates Bezier coefficients from a shape
}
\note{
Directly borrowed for Claude (2008), and also called \code{bezier} there.
Not implemented for open outlines but may be useful for other purposes.
}
\examples{
set.seed(34)
x <- coo_sample(efourier_shape(), 5)
plot(x, ylim=c(-3, 3), asp=1, type='b', pch=20)
b <- bezier(x)
bi <- bezier_i(b$B)
lines(bi, col='red')
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
\seealso{
Other bezier functions: 
\code{\link{bezier_i}()}
}
\concept{bezier functions}
