% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-efourier.R
\name{efourier_shape}
\alias{efourier_shape}
\title{Calculates and draw 'efourier' shapes.}
\usage{
efourier_shape(an, bn, cn, dn, nb.h, nb.pts = 60, alpha = 2, plot = TRUE)
}
\arguments{
\item{an}{\code{numeric}. The \eqn{a_n} Fourier coefficients on which to
calculate a shape.}

\item{bn}{\code{numeric}. The \eqn{b_n} Fourier coefficients on which to
calculate a shape.}

\item{cn}{\code{numeric}. The \eqn{c_n} Fourier coefficients on which to
calculate a shape.}

\item{dn}{\code{numeric}. The \eqn{d_n} Fourier coefficients on which to
calculate a shape.}

\item{nb.h}{\code{integer}. The number of harmonics to use.}

\item{nb.pts}{\code{integer}. The number of points to calculate.}

\item{alpha}{\code{numeric}. The power coefficient associated with the
(usually decreasing) amplitude of the Fourier coefficients (see
\bold{Details}).}

\item{plot}{\code{logical}. Whether to plot or not the shape.}
}
\value{
A list with components:
\itemize{
\item \code{x} \code{vector} of x-coordinates
\item \code{y} \code{vector} of y-coordinates.
}
}
\description{
\code{efourier_shape} calculates a 'Fourier elliptical shape' given Fourier
coefficients (see \code{Details}) or can generate some 'efourier' shapes.
Mainly intended to generate shapes and/or to understand how efourier works.
}
\details{
\code{efourier_shape} can be used by specifying \code{nb.h} and
\code{alpha}. The coefficients are then sampled in an uniform distribution
\eqn{(-\pi ; \pi)} and this amplitude is then divided by
\eqn{harmonicrank^alpha}. If \code{alpha} is lower than 1, consecutive
coefficients will thus increase. See \link{efourier} for the mathematical
background.
}
\examples{
ef <- efourier(bot[1], 24)
efourier_shape(ef$an, ef$bn, ef$cn, ef$dn) # equivalent to efourier_i(ef)
efourier_shape() # is autonomous

panel(Out(a2l(replicate(100,
efourier_shape(nb.h=6, alpha=2.5, plot=FALSE))))) # Bubble family
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.

Ferson S, Rohlf FJ, Koehn RK. 1985. Measuring shape variation of
two-dimensional outlines. \emph{Systematic Biology} \bold{34}: 59-68.
}
\seealso{
Other efourier: \code{\link{efourier_i}},
  \code{\link{efourier}}
}
