% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_slidegap}
\alias{coo_slidegap}
\title{Slides coordinates using the widest gap}
\usage{
coo_slidegap(coo, force)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or a \code{list}, or any \link{Coo} object.}

\item{force}{\code{logical} whether to use the widest gap, with no check, as the real gap}
}
\value{
a \code{matrix} of (x; y) coordinates or a \link{Coo} object.
}
\description{
When slicing a shape using two landmarks, or functions such as \link{coo_up},
an open curve is obtained and the rank of points make wrong/artefactual results.
If the widest gap is > 5 * median of other gaps, then the couple of coordinates
forming this widest gap is used as starting and ending points. This switch helps
to deal with open curves. Examples are self-speaking.
Use \code{force=TRUE} to bypass this check
}
\examples{
cat <- coo_center(shapes[4])
coo_plot(cat)

# we only retain the bottom of the cat
cat_down <- coo_down(cat, slidegap=FALSE)

# see? the segment on the x-axis coorespond to the widest gap.
coo_plot(cat_down)

# that's what we meant
coo_plot(coo_slidegap(cat_down))
}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}}, \code{\link{coo_nb}},
  \code{\link{coo_perimcum}}, \code{\link{coo_perimpts}},
  \code{\link{coo_perim}}, \code{\link{coo_rev}},
  \code{\link{coo_right}}, \code{\link{coo_rotatecenter}},
  \code{\link{coo_rotate}}, \code{\link{coo_samplerr}},
  \code{\link{coo_sample}}, \code{\link{coo_scalex}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slide}}, \code{\link{coo_smoothcurve}},
  \code{\link{coo_smooth}}, \code{\link{coo_template}},
  \code{\link{coo_trans}}, \code{\link{coo_trimbottom}},
  \code{\link{coo_trimtop}}, \code{\link{coo_trim}},
  \code{\link{coo_up}}, \code{\link{is_clockwise}},
  \code{\link{is_closed}},
  \code{\link{is_equallyspacedradii}}

Other sliding functions: \code{\link{coo_slidedirection}},
  \code{\link{coo_slide}}
}

