% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{sample_n}
\alias{sample_n}
\title{Samples n shapes on Momocs objects}
\usage{
sample_n(tbl, size, replace, fac, ...)
}
\arguments{
\item{tbl}{a Momocs object (Coo, Coe)}

\item{size}{numeric how many shapes should we sample}

\item{replace}{logical whether sample should be done with ot without replacement}

\item{fac}{a column name if a \code{$fac} is defined; size is then applied within levels of this factor}

\item{...}{additional arguments to dplyr::sample_n and to maintain generic compatibility}
}
\description{
Sample n shapes from a Momocs object. See examples and \code{?dplyr::sample_n}.
}
\examples{

data(bot)
bot
# samples 5 bottles no matter their type
sample_n(bot, 5)
# 5 bottles of beer and of whisky
table(sample_n(bot, 5, fac="type"))
# many repetitions
table(names(sample_n(bot, 400, replace=TRUE)))

}
\seealso{
Other handling functions: \code{\link{arrange}},
  \code{\link{at_least}}, \code{\link{chop}},
  \code{\link{combine}}, \code{\link{dissolve}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{rename}}, \code{\link{rm_uncomplete}},
  \code{\link{rw_rule}}, \code{\link{sample_frac}},
  \code{\link{select}}, \code{\link{slice}},
  \code{\link{subset.Coo}}, \code{\link{transmute}}
}

