% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-LDA.R
\name{plot_CV}
\alias{plot_CV}
\alias{plot_CV.LDA}
\alias{plot_CV.default}
\title{Plots a cross-validation table as an heatmap}
\usage{
plot_CV(x, ...)

\method{plot_CV}{default}(x, freq = TRUE, rm0 = TRUE, cex = 5,
  round = 2, labels = TRUE, ...)

\method{plot_CV}{LDA}(x, freq = TRUE, rm0 = TRUE, cex = 5, round = 2,
  labels = TRUE, ...)
}
\arguments{
\item{x}{a (cross-validation table) or an LDA object}

\item{...}{only used for the generic}

\item{freq}{logical whether to display frequencies or counts}

\item{rm0}{logical whether to remove zeros}

\item{cex}{numeric to adjust labels in every cell. NA to remove them}

\item{round}{numeric, when freq=TRUE how many decimals should we display}

\item{labels}{logical whether to display freq or counts as text labels}
}
\value{
a ggplot object
}
\description{
Either with frequencies (or percentages) plus marginal sums,
and values as heatmaps. Used in Momocs for plotting cross-validation tables
but may be used for any table (likely with \code{freq=FALSE}).
}
\examples{
data(olea)
ol <- LDA(PCA(opoly(olea, 5)), "domes")
gg <- plot_CV(ol) # just a wrapper for plot_CV(ol$CV.tab) though
gg
}
\seealso{
\link{LDA}, \link{plot.LDA}, and (pretty much the same) \link{Ntable}.
}

