% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_thetapts}
\alias{coo_thetapts}
\title{Calculates the angle of every edge of a shape}
\usage{
coo_thetapts(coo, method = c("atan2", "acos")[1])
}
\arguments{
\item{coo}{a \code{matrix} or a list of (x; y) coordinates.}

\item{method}{one of 'atan2' or 'acos' for a signed or not angle.}
}
\value{
\code{numeric} the angles in radians for every edge.
}
\description{
Returns the angle (in radians) of every edge of a shape,
}
\examples{
data(bot)
b <- coo_sample(bot[1], 64)
coo_thetapts(b)
}
\seealso{
Other coo_ descriptors: \code{\link{coo_area}},
  \code{\link{coo_chull}},
  \code{\link{coo_circularityharalick}},
  \code{\link{coo_circularitynorm}},
  \code{\link{coo_circularity}},
  \code{\link{coo_convexity}},
  \code{\link{coo_eccentricityboundingbox}},
  \code{\link{coo_eccentricityeigen}},
  \code{\link{coo_elongation}}, \code{\link{coo_length}},
  \code{\link{coo_lw}}, \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_tangle}},
  \code{\link{coo_theta3}}, \code{\link{coo_width}}
}

