% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional.R
\name{conditionalmotbf.learning}
\alias{conditionalmotbf.learning}
\alias{conditionalMethod}
\alias{conditional}
\alias{select}
\alias{learn.tree.Intervals}
\alias{BICscoreMoTBF}
\title{Learning Conditional Functions}
\usage{
conditionalMethod(data, nameParents, nameChild, numIntervals,
  POTENTIAL_TYPE, maxParam = NULL, s = NULL, priorData = NULL)

conditional(data, nameParents, nameChild, domainChild, domainParents,
  numIntervals, mm, POTENTIAL_TYPE, maxParam = NULL, s = NULL,
  priorData = NULL)

select(data, nameParents, nameChild, domainChild, domainParents,
  numIntervals, POTENTIAL_TYPE, maxParam = NULL, s = NULL,
  priorData = NULL)

learn.tree.Intervals(data, nameParents, nameChild, domainParents,
  domainChild, numIntervals, POTENTIAL_TYPE, maxParam = NULL, s = NULL,
  priorData = NULL)

BICscoreMoTBF(conditionalfunction, data, nameParents, nameChild)
}
\arguments{
\item{data}{A dataset of class \code{"data.frame"}.}

\item{nameParents}{A \code{"character"} vector with the names of the parent variables.}

\item{nameChild}{The name of the child variable as a \code{"character"} string.}

\item{numIntervals}{A \code{"numeric"} value indicating the maximum number of intervals in which we 
want to split the domain of the parent variables.}

\item{POTENTIAL_TYPE}{A \code{"character"} string specifying the posibles potential
types, must be one of \code{"MOP"} or \code{"MTE"}. You can specify just the initial letter.}

\item{maxParam}{A \code{"numeric"} value which indicate the maximum number of coefficients in the function. By default it is \code{NULL}; 
if not, the output is the function which gets the best BIC with at most this number of parameters.}

\item{s}{A \code{"numeric"} coefficient which fixes the confidence of the prior knowledge 
we are going to introduce. By default it is \code{NULL}, only we must modify it if we want 
to incorporate prior information to the fits.}

\item{priorData}{Prior dataset with values of the variables we have information apriori about.
This dataset must be of \code{"data.frame"} class.}

\item{domainChild}{An \code{"numeric"} array with the range of the child variable.}

\item{domainParents}{A matrix of class \code{"matrix"} with the range of the parent 
variables or an \code{"numeric"} array if there is a only one parent.}

\item{mm}{One of the inputs and the output of the recursive function \code{"conditional"}.}

\item{conditionalfunction}{The output of the function \code{learn.tree.Intervals}.}
}
\value{
The main function \code{conditionalMethod} returns a list with the name of the parents, 
the different intervals and  the fitted functions.
}
\description{
Collection of functions for learning conditional MoTBFs,
computing the internal BIC, selecting the parents that get 
the best BIC value, and other internal functions needed to get the 
final conditionals.
}
\details{
The main function \code{conditionalMethod} fits truncated functions for a variable which depends
on others variables. The domain of the parent variables is splitted
in different intervals and univariate functions are fitted in these 
ranges. The rest of the described functions are internal ones of the main function.
}
\examples{
## Dataset
X <- rnorm(1000)
Y <- rbeta(1000, shape1 = abs(X)/2, shape2 = abs(X)/2)
Z <- rnorm(1000, mean = Y)
data <- data.frame(X = X, Y = Y, Z = Z)

## Conditional Method
parents <- c("X","Y")
child <- "Z"
intervals <- 2

potential <- "MTE"
fMTE <- conditionalMethod(data, nameParents = parents, nameChild = child, 
numIntervals = intervals, POTENTIAL_TYPE = potential)
printConditional(fMTE)

##############################################################################
\donttest{
potential <- "MOP"
fMOP <- conditionalMethod(data, nameParents = parents, nameChild = child,
numIntervals = intervals, POTENTIAL_TYPE = potential, maxParam = 15)
printConditional(fMOP)
}
##############################################################################

##############################################################################
## Internal functions: Not needed to run #####################################
##############################################################################
\donttest{
domainP <- range(data[,parents])
domainC <- range(data[, child])
t <- conditional(data, nameParents = parents, nameChild = child,
domainParents = domainP, domainChild = domainC, numIntervals = intervals,
mm = NULL, POTENTIAL_TYPE = potential)
printConditional(t)
selection <- select(data, nameParents = parents, nameChild = child,
domainParents = domainP, domainChild = domainC, numIntervals = intervals,
POTENTIAL_TYPE = potential)
parent1 <- selection$parent; parent1
domainParent1 <- range(data[,parent1])
treeParent1 <- learn.tree.Intervals(data, nameParents = parent1,
nameChild = child, domainParents = domainParent1, domainChild = domainC,
numIntervals = intervals, POTENTIAL_TYPE = potential)
BICscoreMoTBF(treeParent1, data, nameParents = parent1, nameChild = child)
}
###############################################################################
###############################################################################
}
\seealso{
\link{printConditional}
}
