% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{simulateMobilityNetworks}
\alias{simulateMobilityNetworks}
\alias{simulateDistributionNetworks}
\alias{monanSimulate}
\title{simulateMobilityNetworks}
\usage{
simulateMobilityNetworks(
  state,
  effects,
  parameters,
  allowLoops,
  burnin,
  thinning,
  nSimulations,
  cache = NULL
)

simulateDistributionNetworks(
  state,
  effects,
  parameters,
  allowLoops,
  burnin,
  thinning,
  nSimulations,
  cache = NULL
)

monanSimulate(
  state,
  effects,
  parameters,
  allowLoops,
  burnin,
  thinning,
  nSimulations,
  cache = NULL
)
}
\arguments{
\item{state}{An object of class "processState.monan" that contains all relevant information about
nodesets, and covariates. Further, an edgelist of the dependent variable needs
to be specified with the initial mobility network as starting value for the
simulation. For a large enough burn-in, any initial mobility network is allowed.}

\item{effects}{An object of class "effectsList.monan" that specifies the model.}

\item{parameters}{The parameters associated with the effects that shall be used
in the simulations.}

\item{allowLoops}{Logical: can individuals/resources stay in their origin?}

\item{burnin}{The number of simulation steps that are taken before the first draw of a
network is taken. A number too small will mean the first draw is influenced
by the initially specified network. A recommended value for the lower bound is 3 * n_Individuals *
n_locations.}

\item{thinning}{The number of simulation steps that are taken between two draws of a
network. A recommended value for the lower bound is n_Individuals * n_locations.}

\item{nSimulations}{The number of mobility networks to be simulated.}

\item{cache}{Outdated parameter, no need to specify.}
}
\value{
An object of class "sims.monan" with nSimulations entries, where each entry contains a further list with the
state and the cache of the current simulation stored.
}
\description{
Simulates mobility networks for given data, effects, and parameters. This
function is mainly interesting to explore the behavior of the model or to
do counter-factual simulations.
}
\examples{
\donttest{
# simulate a mobility network
# note that thinning and burn-in values are for this example only
# in real cases, choose values aprrox. times 10
mySimDN <- simulateMobilityNetworks(
  myState,
  myEffects,
  parameters = c(2, 1, 1.5, 0.1, -1, -0.5),
  allowLoops = TRUE,
  burnin = 450,
  thinning = 150,
  nSimulations = 10
)

mySimDN[[1]]
}
}
