% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pedigree.R
\name{get.pedigree3}
\alias{get.pedigree3}
\title{Derive pedigree parents and grandparents}
\usage{
get.pedigree3(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  founder.zero = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{founder.zero}{Parents of founders are displayed as "0" (default: TRUE)}
}
\value{
Pedigree-file (parents + grandparents) for in gen/database/cohorts selected individuals
}
\description{
Derive pedigree for selected individuals including parents/grandparents
}
\examples{
data(ex_pop)
get.pedigree3(ex_pop, gen=3)
}
