% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pedmap.R
\name{get.pedmap}
\alias{get.pedmap}
\title{Generate plink-file (pedmap)}
\usage{
get.pedmap(population, path = NULL, database = NULL, gen = NULL,
  cohorts = NULL, chromosomen = "all")
}
\arguments{
\item{population}{Population list}

\item{path}{Location to save pedmap-file}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{chromosomen}{Beschraenkung des Genotypen auf bestimmte Chromosomen (default: 1)}
}
\value{
Ped and map-file for in gen/database/cohorts selected individuals
}
\description{
Generate a ped and map file (PLINK format) for selected groups and chromosome
}
\examples{
data(ex_pop)
\donttest{get.pedmap(path=tempdir(), ex_pop, gen=2)}
}
