% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varyprop.R
\name{mixregPvaryGen}
\alias{mixregPvaryGen}
\title{Varying Proportion Mixture Data Generator}
\usage{
mixregPvaryGen(n, C = 2)
}
\arguments{
\item{n}{number of observations.}

\item{C}{number of mixture components. Default is 2.}
}
\value{
A list containing the following elements:
\item{x}{vector of length n.}
\item{y}{vector of length n.}
\item{true_p}{n by C matrix of probabilities of an observations belonging to each component.}
}
\description{
`mixregPvaryGen' is used to generate a mixture of normal distributions with varying proportions:
\deqn{Y|_{\boldsymbol{x},Z=z} \sim \sum_{c=1}^C\pi_c(z)N(\boldsymbol{x}^{\top}\boldsymbol{\beta}_c,\sigma_c^2).}
See \code{\link{mixregPvary}} for details.
}
\examples{
mixregPvaryGen(n = 100, C = 2)
}
\seealso{
\code{\link{mixregPvary}}
}
