% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIM.R
\name{simonestep}
\alias{simonestep}
\title{One step estimation of iterative backfitting estimator (FIB) of single index mixture models}
\usage{
simonestep(x, y, h, est_b = NULL, ini = NULL, grid = NULL)
}
\arguments{
\item{x}{independent variable; n by p matrix, each row is an observation}

\item{y}{dependent variable vector}

\item{h}{bandwidth}

\item{est_b}{alpha transpose in the paper, similar to beta in regression model}

\item{ini}{initial values: list(est_p=proportion of each component,est_mu=mean;est_var= var of each component)}

\item{grid}{grid point for linear interpolating.}
}
\value{
est_p:estimated proportion of each component \cr
est_mu:estimated mean of each component \cr
est_var:estimated variance of each component \cr
est_b:estimated beta of the regressions
}
\description{
One step estimation of iterative backfitting estimator (FIB) of single index mixture models
}
\examples{
 xx=NBA[,c(1,2,4)];
 yy=NBA[,3];
 x=xx/t(matrix(rep(sqrt(diag(var(xx))),length(yy)),nrow=3));x=as.matrix(x);
 y=yy/sd(yy);y=as.vector(y)
 ini_bs=sinvreg(x,y)
 ini_b=ini_bs$direction[,1];
 h=0.3442;
 est_b=ini_b
 #used a smaller sample for a quicker demonstration of the function
 set.seed(123)
 est_onestep=simonestep(x[1:50,],y[1:50],h,ini_b);
}
