% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/root_selection.R
\name{root_selection}
\alias{root_selection}
\title{Root Selection Method for Univariate Finite Normal Mixture Models}
\usage{
root_selection(y, n, k, int, ini = NULL, true = NULL)
}
\arguments{
\item{y}{observations vector}

\item{n}{number of observations: length(y)}

\item{k}{number of components}

\item{int}{number of initial values for EM algorithm.}

\item{ini}{initial values of parameter list(p=p,m=m,s=s); Default is estimated from y.}

\item{true}{true parameters. true = c(pr[1],mu[1],sd[1],pr[2],mu[2],sd[2],...)
if not specified, then will estimated from initical value using normal mixture model.}
}
\value{
estks: estimated KS statistic
estcvm: Cramér–von Mises statistic
estkui: Kuiper's statistic
estwatson: Watson statistic
estad: Anderson Darling statistic
cpks: 1:result is significant based on KS statistic; 0: o.w.
cpcvm:1:result is significant based on Cramér–von Mises statistic; 0: o.w.
cpkui:1:result is significant based on Kuiper's statistic; 0: o.w.
cpwatson:1:result is significant based on Watson statistic; 0: o.w.
cpad:1:result is significant based on  Anderson Darling statist; 0: o.w.
}
\description{
Root Selection Method for Univariate Finite Normal Mixture Models
}
\examples{
int <- 7; n <- 100; k=3
pr<- c(0.3,0.3,0.4);mu <- c(0,2,5);sd <- c(1,0.5,1)
y1 <- rnorm(pr[1]*n,mu[1],sd[1]); y2 <- rnorm(pr[2]*n,mu[2],sd[2]);
y3 <- rnorm(pr[3]*n,mu[3],sd[3])
y <- c(y1,y2,y3); rm(y1,y2,y3)
out=root_selection(y,n,k,int)

}
