% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_mt}
\alias{plot_mt}
\title{Plot the result of a mt test \code{\link[phyloseq:mt-methods]{phyloseq::mt()}}}
\usage{
plot_mt(mt = NULL, alpha = 0.05, color_tax = "Class", taxa = "Species")
}
\arguments{
\item{mt}{(required) Result of a mt test from the function \code{\link[phyloseq:mt-methods]{phyloseq::mt()}}.}

\item{alpha}{(default: 0.05) Choose the cut off p-value to plot taxa.}

\item{color_tax}{(default: "Class") A taxonomic level to color the points.}

\item{taxa}{(default: "Species") The taxonomic level you choose for x-positioning.}
}
\value{
a \code{\link[ggplot2]{ggplot}}2 plot of result of a mt test
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Graphical representation of mt test.
}
\examples{
\donttest{
# Filter samples that don't have Time
data_fungi_mini2 <- subset_samples(data_fungi_mini, !is.na(Time))
res <- mt(data_fungi_mini2, "Time", method = "fdr", test = "f", B = 300)
plot_mt(res)
plot_mt(res, taxa = "Genus", color_tax = "Order")
}
}
\seealso{
\code{\link[phyloseq:mt-methods]{phyloseq::mt()}}
}
\author{
Adrien Taudière
}
