% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{venn_pq}
\alias{venn_pq}
\title{Venn diagram of \code{\link{phyloseq-class}} object}
\usage{
venn_pq(physeq, fact, min_nb_seq = 0, print_values = TRUE)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required): Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{min_nb_seq}{(default: 0)): minimum number of sequences by OTUs by
samples to take into count this OTUs in this sample. For example,
if min_nb_seq=2,each value of 2 or less in the OTU table
will be change into 0 for the analysis}

\item{print_values}{(logical) Print (or not) the table of number of OTUs
for each combination.
If print_values is TRUE the object is not a ggplot object.
Please use print_values = FALSE if you want to add ggplot function
(cf example).}
}
\value{
A \code{\link{ggplot}}2 plot representing Venn diagram of
modalities of the argument \code{factor}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("enterotype")
venn_pq(enterotype, fact = "SeqTech")
\donttest{
venn_pq(enterotype, fact = "ClinicalStatus")
venn_pq(enterotype, fact = "Nationality", print_values = FALSE)
venn_pq(enterotype, fact = "ClinicalStatus", print_values = FALSE) +
  scale_fill_hue()
venn_pq(enterotype, fact = "ClinicalStatus", print_values = FALSE) +
  scale_fill_hue()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[venneuler]{venneuler}}
}
\author{
Adrien Taudière
}
