% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{accu_plot}
\alias{accu_plot}
\title{Plot accumulation curves for \code{\link[phyloseq]{phyloseq-class}} object}
\usage{
accu_plot(
  physeq,
  fact = NULL,
  add_nb_seq = TRUE,
  step = NULL,
  by.fact = FALSE,
  ci_col = NULL,
  col = NULL,
  lwd = 3,
  leg = TRUE,
  print_sam_names = FALSE,
  ci = 2,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor in \code{physeq@sam_data} used to plot
different lines}

\item{add_nb_seq}{(default: TRUE, logical)
Either plot accumulation curves using sequences or using samples}

\item{step}{(Integer) distance among points calculated to plot lines. A
low value give better plot but is more time consuming.
Only used if \code{add_nb_seq} = TRUE.}

\item{by.fact}{(default: FALSE, logical)
First merge the OTU table by factor to plot only one line by factor}

\item{ci_col}{Color vector for confidence interval.
Only use if \code{add_nb_seq} = FALSE.
If \code{add_nb_seq} = TRUE, you can use ggplot to modify the plot.}

\item{col}{Color vector for lines. Only use if \code{add_nb_seq} = FALSE.
If \code{add_nb_seq} = TRUE, you can use ggplot to modify the plot.}

\item{lwd}{(default: 3) thickness for lines. Only use if \code{add_nb_seq} = FALSE.}

\item{leg}{(default: TRUE, logical) Plot legend or not. Only use if \code{add_nb_seq} = FALSE.}

\item{print_sam_names}{(default: FALSE, logical) Print samples names or not?
Only use if \code{add_nb_seq} = TRUE.}

\item{ci}{(default: 2, integer) Confidence interval value used to multiply the
standard error to plot confidence interval}

\item{...}{Additional arguments passed on to \code{\link[ggplot2]{ggplot}}
if \code{add_nb_seq} = TRUE or to \code{\link{plot}} if \code{add_nb_seq} = FALSE}
}
\value{
A \code{\link[ggplot2]{ggplot}}2 plot representing the richness
accumulation plot if add_nb_seq = TRUE, else, if add_nb_seq = FALSE
return a base plot.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Note that as most bioinformatic pipeline discard singleton, accumulation curves from metabarcoding
cannot be interpreted in the same way as with conventional biodiversity sampling techniques.
}
\examples{
\donttest{
data("GlobalPatterns", package = "phyloseq")
GP <- subset_taxa(GlobalPatterns, GlobalPatterns@tax_table[, 1] == "Archaea")
GP <- rarefy_even_depth(subset_samples_pq(GP, sample_sums(GP) > 3000))
p <- accu_plot(GP, "SampleType", add_nb_seq = TRUE, by.fact = TRUE, step = 10)
p <- accu_plot(GP, "SampleType", add_nb_seq = TRUE, step = 10)

p + theme(legend.position = "none")

p + xlim(c(0, 400))
}
}
\seealso{
\code{\link[vegan]{specaccum}} \code{\link[=accu_samp_threshold]{accu_samp_threshold()}}
}
\author{
Adrien Taudière
}
