% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcConnectivity.R
\name{calcMantel}
\alias{calcMantel}
\title{Calculate Mantel correlation (rM) from points and/or distances.}
\usage{
calcMantel(
  targetPoints = NULL,
  originPoints = NULL,
  targetDist = NULL,
  originDist = NULL
)
}
\arguments{
\item{targetPoints}{A sf \code{POINTS} object, with length number of animals
tracked.  Each point indicates the point estimate location in the
non-release season.}

\item{originPoints}{A sf \code{POINTS} object, with length number of animals
tracked.  Each point indicates the release location of an animal.}

\item{targetDist}{Distances between the target locations of the tracked
animals.  Symmetric matrix with number of animals rows and columns,
although really you only need the lower triangle filled in.}

\item{originDist}{Distances between the origin locations of the tracked
animals.  Symmetric matrix with number of animals rows and columns,
although really you only need the lower triangle filled in.}
}
\value{
\code{calcMantel} returns a list with elements:
\describe{
  \item{\code{pointCorr}}{Simple point estimate of Mantel correlation.}
  \item{\code{originDist, targetDist}}{Distances between each pair of
  \code{originPoints} and each pair of \code{targetPoints}, respectively,
  in meters. If you used distances as inputs instead, then these are just
  what you fed in.}
}
}
\description{
Calculation of rM from POINTS geolocators and/or GPS
data, not accounting for uncertainty. If you've already calculated
distances between points, you can use those instead.
}
\examples{
data(OVENdata) # Ovenbird
rM0 <- calcMantel(originPoints = OVENdata$originPoints, # Capture Locations
                  targetPoints = OVENdata$targetPoints) # Target locations
str(rM0)
}
\references{
Ambrosini, R., A. P. Moller, and N. Saino. 2009. A quantitative measure of
migratory connectivity. Journal of Theoretical Biology 257:203-211.
\doi{10.1016/j.jtbi.2008.11.019}
}
\seealso{
\code{\link{estMantel}}, \code{\link{calcMC}}, \code{\link{estMC}}
}
