% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_plan_task.R
\docType{class}
\name{ms_plan_task}
\alias{ms_plan_task}
\title{Microsoft Planner Plan Task}
\format{
An R6 object of class \code{ms_plan_task}, inheriting from \code{ms_object}.
}
\description{
Class representing a task within a plan of a Microsoft Planner.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this task.
\item \code{type}: always "plan_task" for plan task object.
\item \code{properties}: The task properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new plan task object. Do not call this directly; see 'Initialization' below.
\item \code{update(...)}: Update the plan task metadata in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the plan task
\item \code{sync_fields()}: Synchronise the R object with the plan task metadata in Microsoft Graph.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{list_tasks} methods of the \code{\link{ms_plan}} class.
Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual plan task.
}

\section{List methods}{

All \verb{list_*} methods have \code{filter} and \code{n} arguments to limit the number of results. The former should be an \href{https://docs.microsoft.com/en-us/graph/query-parameters#filter-parameter}{OData expression} as a string to filter the result set on. The latter should be a number setting the maximum number of (filtered) results to return. The default values are \code{filter=NULL} and \code{n=Inf}. If \code{n=NULL}, the \code{ms_graph_pager} iterator object is returned instead to allow manual iteration over the results.

Support in the underlying Graph API for OData queries is patchy. Not all endpoints that return lists of objects support filtering, and if they do, they may not allow all of the defined operators. If your filtering expression results in an error, you can carry out the operation without filtering and then filter the results on the client side.
}

\seealso{
\code{\link{ms_plan}}, \code{\link{ms_plan_bucket}}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/resources/planner-overview?view=graph-rest-beta}{Plans overview}
}
