% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{personal_onedrive}
\alias{personal_onedrive}
\alias{business_onedrive}
\alias{sharepoint_site}
\title{OneDrive and Sharepoint Online clients}
\usage{
personal_onedrive(app = .microsoft365r_app_id,
  scopes = c("Files.ReadWrite.All", "User.Read"), ...)

business_onedrive(tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"), scopes = ".default", ...)

sharepoint_site(site_url = NULL, site_id = NULL,
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"), scopes = ".default", ...)
}
\arguments{
\item{app}{A custom app registration ID to use for authentication. For \code{personal_onedrive}, the default is to use Microsoft365R's internal app ID. For \code{business_onedrive} and \code{sharepoint_site}, see below.}

\item{scopes}{The Microsoft Graph scopes (permissions) to obtain.}

\item{...}{Optional arguments to be passed to \code{AzureGraph::create_graph_login}.}

\item{tenant}{For \code{business_onedrive} and \code{sharepoint_site}, the name of your Azure Active Directory (AAD) tenant. If not supplied, use the value of the \code{CLIMICROSOFT365_TENANT} environment variable, or "common" if that is unset.}

\item{site_url, site_id}{For \code{sharepoint_site}, the web URL and ID of the SharePoint site to retrieve. Supply one or the other, but not both.}
}
\value{
For \code{personal_onedrive} and \code{business_onedrive}, an object of class \code{ms_drive}. For \code{sharepoint_site}, an object of class \code{ms_site}.
}
\description{
OneDrive and Sharepoint Online clients
}
\details{
\code{personal_onedrive}, \code{business_onedrive} and \code{sharepoint_site} provide easy access to OneDrive, OneDrive for Business, and SharePoint Online respectively. On first use, they will call your web browser to authenticate with Azure Active Directory, in a similar manner to other web apps. You will get a dialog box asking for permission to access your information. You only have to authenticate once per client; your credentials will be saved and reloaded in subsequent sessions.

When authenticating, you can pass optional arguments in \code{...} which will ultimately be received by \code{AzureAuth::get_azure_token}. In particular, if your machine doesn't have a web browser available to authenticate with (for example if you are in a remote RStudio Server session), pass \code{auth_type="device_code"} which is intended for such scenarios.
}
\section{Authenticating to Microsoft 365 Business services}{

Authenticating to Microsoft 365 Business services (SharePoint and OneDrive for Business) has some specific complexities.

The default "common" tenant for \code{business_onedrive} and \code{sharepoint_site} attempts to detect your actual tenant from your saved credentials in your browser. This may not always succeed, for example if you have a personal account that is also a guest account in a tenant. In this case, supply the actual tenant name, either in the \code{tenant} argument or in the \code{CLIMICROSOFT365_TENANT} environment variable. The latter allows sharing authentication details with the \href{https://pnp.github.io/cli-microsoft365/}{CLI for Microsoft 365}.

The default when authenticating to these services is for Microsoft365R to use its own internal app ID. Depending on your organisation's security policy, you may have to get an admin to grant it access to your tenant. As an alternative to the default app ID, you (or your admin) can create your own app registration: it should have a native redirect URI of \verb{http://localhost:1410}, and the "public client" option should be enabled if you want to use the device code authentication flow. You can supply your app ID either via the \code{app} argument, or in the environment variable \code{CLIMICROSOFT365_AADAPPID}.

If creating your own app registration is impractical, it's possible to work around access issues by piggybacking on the CLI for Microsoft365. By setting the R option \code{microsoft365r_use_cli_app_id} to a non-NULL value, authentication will be done using the CLI's app ID. Technically this app still requires admin approval, but it is in widespread use and so may already be allowed in your organisation. Be warned that this solution may draw the attention of your admin!
}

\examples{
\dontrun{

personal_onedrive()

# authenticating without a browser
personal_onedrive(auth_type="device_code")

odb <- business_onedrive("mycompany")
odb$list_items()

site <- sharepoint_site("https://mycompany.sharepoint.com/sites/my-site-name", tenant="mycompany")
site$get_drive()$list_items()


# you can also use your own app registration ID:
business_onedrive(app="app_id")
sharepoint_site("https://mycompany.sharepoint.com/sites/my-site-name", app="app_id")

# using the app ID for the CLI for Microsoft 365: set a global option
options(microsoft365r_use_cli_app_id=TRUE)
business_onedrive()
sharepoint_site("https://mycompany.sharepoint.com/sites/my-site-name")

}
}
\seealso{
\link{ms_drive}, \link{ms_site}, \link[AzureGraph:graph_login]{AzureGraph::create_graph_login}, \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}

\href{https://pnp.github.io/cli-microsoft365/}{CLI for Microsoft 365} -- a commandline tool for managing Microsoft 365
}
