% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{mexico_states_df}
\alias{mexico_states_df}
\title{Mexican States Demographics (2020)}
\format{
A data frame with 32 observations and 11 variables:
\describe{
  \item{region}{Geographic region of the state (character)}
  \item{state_name}{State name (character)}
  \item{state_name_official}{Official state name (character)}
  \item{state_abbr}{State abbreviation (character)}
  \item{state_abbr_official}{Official state abbreviation (character)}
  \item{year}{Year of the data (numeric)}
  \item{pop}{Total population (integer)}
  \item{pop_male}{Male population (integer)}
  \item{pop_female}{Female population (integer)}
  \item{afromexican}{Number of people who identify as Afro-Mexican (integer)}
  \item{indigenous_language}{Number of people who speak an indigenous language (integer)}
}
}
\source{
Data taken from the MexBrewer package version 0.0.2
}
\usage{
data(mexico_states_df)
}
\description{
This dataset, mexico_states_df, is a data frame containing population estimates and demographic indicators
for all 32 Mexican states in the year 2020. It includes total population, gender-specific counts, and
the number of people who self-identify as Afro-Mexican or speak an indigenous language.
}
\details{
The dataset name has been kept as 'mexico_states_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MexicoDataAPI package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
